// Autor: Ante Derek

#include <iostream>
#include <string>
#include <algorithm>
#include <cctype>
#include <cassert>

using namespace std;

pair<int, int> parse_term(const string &t) {
  int a = 1;
  int i = 0;
  if (t[0] != 'x') {
    a = 0;
    while (i < (int)t.size() && isdigit(t[i])) {
      a = a*10+t[i]-'0';
      i++;
    }
  }
  assert(i < (int)t.size());
  assert(t[i] == 'x');
  i++;
  assert(t[i] == '^' || i == (int)t.size());
  i++;
  int b = 1;
  if (i < (int)t.size() && isdigit(t[i])) {
    b = 0;
    while (i < (int)t.size() && isdigit(t[i])) {
      b = b*10+t[i]-'0';
      i++;
    }
  }
  assert(i >= (int)t.size());
  return {a, b};
}

vector<pair<int, int>> parse_poli(const string &t) {
  vector<pair<int, int>> sol;
  string current;
  for (int i=0; i<(int)t.size(); i++) 
    if (t[i] == '+') {
      sol.push_back(parse_term(current));
      current = "";
    }
    else
      current += t[i];
  sol.push_back(parse_term(current));
  return sol;
}

void mul(int a, int b) { cout << "mul d" << a << " d" << b << endl; }
void add(int a, int b) { cout << "add d" << a << " d" << b << endl; }

// D9 - total
// D8 - current 
// D7 - null
// D0 - x
void gen(int a, int b) {
  mul(1, 7);
  add(1, 0);
  for (int i=0; i<b-1; i++)
    mul(1, 0);
  while (a > 0) {
    if (a%2)
      add(9, 1);
    add(1, 1);
    a /= 2;
  }
}

int main() {
  // Test
  assert(parse_term("x") == make_pair(1, 1));
  assert(parse_term("x^1") == make_pair(1, 1));
  assert(parse_term("x^2") == make_pair(1, 2));
  assert(parse_term("x^234") == make_pair(1, 234));
  assert(parse_term("1x") == make_pair(1, 1));
  assert(parse_term("321x") == make_pair(321, 1));
  assert(parse_term("3x^4") == make_pair(3, 4));
  assert(parse_term("323423x^423234") == make_pair(323423, 423234));
  assert(parse_poli("3x^4") == (vector<pair<int, int>>{{3, 4}}));
  assert(parse_poli("3x^4+x^2+34x") ==
         (vector<pair<int, int>>{{3, 4}, {1, 2}, {34, 1}}));
  assert(parse_poli("3x^43+2x^32+34x") ==
         (vector<pair<int, int>>{{3, 43}, {2, 32}, {34, 1}}));
  // End test
  string poli;
  cin >> poli;
  for (auto p : parse_poli(poli))
    gen(p.first, p.second);
  mul(0, 7);
  add(0, 9);
  return 0;
}
